extends Node

##Game global signals
# player signals
signal on_boost(stair_nmbr)
signal on_step
signal on_long_stair(direction) # -1 for left 1 for right
var cur_stars:int=1
var globalRandom = RandomNumberGenerator.new()
var total_stars_number:int
var cur_stars_collected:int

#level items


const stair_blocks : Dictionary = {
	0 : {
		0 : preload("res://scenes/level_elements/easy/easy_1.tscn"),
		1 : preload("res://scenes/level_elements/easy/easy_2.tscn"),
		2 : preload("res://scenes/level_elements/easy/easy_3.tscn"),
		3 : preload("res://scenes/level_elements/easy/easy_4.tscn"),
		4 : preload("res://scenes/level_elements/easy/easy_5.tscn"),
		5 : preload("res://scenes/level_elements/easy/easy_6.tscn"),
		6 : preload("res://scenes/level_elements/easy/easy_7.tscn"),
		7 : preload("res://scenes/level_elements/easy/easy_8.tscn"),
		8 : preload("res://scenes/level_elements/easy/easy_9.tscn"),
		9 : preload("res://scenes/level_elements/easy/easy_10.tscn"),
		10 : preload("res://scenes/level_elements/easy/easy_11.tscn"),
		11 : preload("res://scenes/level_elements/easy/easy_12.tscn"),
		12 : preload("res://scenes/level_elements/easy/easy_13.tscn"),
		13 : preload("res://scenes/level_elements/easy/easy_14.tscn"),
		14 : preload("res://scenes/level_elements/easy/easy_15.tscn"),
		15 : preload("res://scenes/level_elements/easy/easy_16.tscn"),
		16 : preload("res://scenes/level_elements/easy/easy_17.tscn"),
		17 : preload("res://scenes/level_elements/easy/easy_18.tscn"),
		18 : preload("res://scenes/level_elements/easy/easy_19.tscn"),
		19 : preload("res://scenes/level_elements/easy/easy_20.tscn"),
		20 : preload("res://scenes/level_elements/easy/easy_21.tscn"),
		21 : preload("res://scenes/level_elements/easy/easy_22.tscn"),
		22 : preload("res://scenes/level_elements/easy/easy_23.tscn"),
		23 : preload("res://scenes/level_elements/easy/easy_24.tscn"),
		24 : preload("res://scenes/level_elements/easy/easy_25.tscn"),
		25 : preload("res://scenes/level_elements/easy/easy_26.tscn"),
		26 : preload("res://scenes/level_elements/easy/easy_27.tscn"),
		27 : preload("res://scenes/level_elements/easy/easy_28.tscn"),
		28 : preload("res://scenes/level_elements/easy/easy_29.tscn"),
		29 : preload("res://scenes/level_elements/easy/easy_30.tscn"),
	},
	1 : {
		0 : preload("res://scenes/level_elements/medium/medium_1.tscn"),
		1 : preload("res://scenes/level_elements/medium/medium_2.tscn"),
		2 : preload("res://scenes/level_elements/medium/medium_3.tscn"),
		3 : preload("res://scenes/level_elements/medium/medium_4.tscn"),
		4 : preload("res://scenes/level_elements/medium/medium_5.tscn"),
		5 : preload("res://scenes/level_elements/medium/medium_6.tscn"),
		6 : preload("res://scenes/level_elements/medium/medium_7.tscn"),
		7 : preload("res://scenes/level_elements/medium/medium_8.tscn"),
		8 : preload("res://scenes/level_elements/medium/medium_9.tscn"),
		9 : preload("res://scenes/level_elements/medium/medium_10.tscn"),
		10 : preload("res://scenes/level_elements/medium/medium_11.tscn"),
		11 : preload("res://scenes/level_elements/medium/medium_12.tscn"),
		12 : preload("res://scenes/level_elements/medium/medium_13.tscn"),
		13 : preload("res://scenes/level_elements/medium/medium_14.tscn"),
		14 : preload("res://scenes/level_elements/medium/medium_15.tscn"),
		15 : preload("res://scenes/level_elements/medium/medium_16.tscn"),
		16 : preload("res://scenes/level_elements/medium/medium_17.tscn"),
		17 : preload("res://scenes/level_elements/medium/medium_18.tscn"),
		18 : preload("res://scenes/level_elements/medium/medium_19.tscn"),
		19 : preload("res://scenes/level_elements/medium/medium_20.tscn"),
		20 : preload("res://scenes/level_elements/medium/medium_21.tscn"),
		21 : preload("res://scenes/level_elements/medium/medium_22.tscn"),
		22 : preload("res://scenes/level_elements/medium/medium_23.tscn"),
		23 : preload("res://scenes/level_elements/medium/medium_24.tscn"),
		24 : preload("res://scenes/level_elements/medium/medium_25.tscn"),
		25 : preload("res://scenes/level_elements/medium/medium_26.tscn"),
		26 : preload("res://scenes/level_elements/medium/medium_27.tscn"),
		27 : preload("res://scenes/level_elements/medium/medium_28.tscn"),
		28 : preload("res://scenes/level_elements/medium/medium_29.tscn"),
		29 : preload("res://scenes/level_elements/medium/medium_30.tscn"),
	},
	2: {
		0 : preload("res://scenes/level_elements/hard/hard_1.tscn"),
		1 : preload("res://scenes/level_elements/hard/hard_2.tscn"),
		2 : preload("res://scenes/level_elements/hard/hard_3.tscn"),
		3 : preload("res://scenes/level_elements/hard/hard_4.tscn"),
		4 : preload("res://scenes/level_elements/hard/hard_5.tscn"),
		5 : preload("res://scenes/level_elements/hard/hard_6.tscn"),
		6 : preload("res://scenes/level_elements/hard/hard_7.tscn"),
		7 : preload("res://scenes/level_elements/hard/hard_8.tscn"),
		8 : preload("res://scenes/level_elements/hard/hard_9.tscn"),
		9 : preload("res://scenes/level_elements/hard/hard_10.tscn"),
		10 : preload("res://scenes/level_elements/hard/hard_11.tscn"),
		11 : preload("res://scenes/level_elements/hard/hard_12.tscn"),
		12 : preload("res://scenes/level_elements/hard/hard_13.tscn"),
		13 : preload("res://scenes/level_elements/hard/hard_14.tscn"),
		14 : preload("res://scenes/level_elements/hard/hard_15.tscn"),
		15 : preload("res://scenes/level_elements/hard/hard_16.tscn"),
		16 : preload("res://scenes/level_elements/hard/hard_17.tscn"),
		17 : preload("res://scenes/level_elements/hard/hard_18.tscn"),
		18 : preload("res://scenes/level_elements/hard/hard_19.tscn"),
		19 : preload("res://scenes/level_elements/hard/hard_20.tscn"),
		20 : preload("res://scenes/level_elements/hard/hard_21.tscn"),
		21 : preload("res://scenes/level_elements/hard/hard_22.tscn"),
		22 : preload("res://scenes/level_elements/hard/hard_23.tscn"),
		23 : preload("res://scenes/level_elements/hard/hard_24.tscn"),
		24 : preload("res://scenes/level_elements/hard/hard_25.tscn"),
		25 : preload("res://scenes/level_elements/hard/hard_26.tscn"),
		26 : preload("res://scenes/level_elements/hard/hard_27.tscn"),
		27 : preload("res://scenes/level_elements/hard/hard_28.tscn"),
		28 : preload("res://scenes/level_elements/hard/hard_29.tscn"),
		29 : preload("res://scenes/level_elements/hard/hard_30.tscn"),
	},
	4 : preload("res://scenes/level_elements/final.tscn")
	
}
const long_stairs : Dictionary =  {
	0 : preload("res://scenes/level_elements/easy/long_right_easy.tscn"),
	1 : preload("res://scenes/level_elements/easy/long_left_easy.tscn")
}


const backgrounds : Dictionary = {
	0 : preload("res://assets/textures/UI/Background_Texture_1.png"),
	1 : preload("res://assets/textures/UI/Background_Texture_2.png"),
	2 : preload("res://assets/textures/UI/Background_Texture_3.png")
}

const stair_jump_mater : Material = preload("res://assets/materials/stair_element_jumped_material.material")
const stair_normal_material : Material = preload("res://assets/materials/stair_blue.material")


const ball_skins : Dictionary = {
	1 : preload("res://assets/textures/skins/Ball_Skin_1.png"),
	2 : preload("res://assets/textures/skins/Ball_Skin_2.png"),
	3 : preload("res://assets/textures/skins/Ball_Skin_3.png"),
	4 : preload("res://assets/textures/skins/Ball_Skin_4.png"),
	5 : preload("res://assets/textures/skins/Ball_Skin_5.png"),
	6 : preload("res://assets/textures/skins/Ball_Skin_6.png"),
	7 : preload("res://assets/textures/skins/Ball_Skin_77.png")
}

#const level_template = preload("res://scenes/levels/level_generator.tscn")
const level_template : PackedScene = preload("res://scenes/levels/procedural_levels.tscn")


var current_level

func _ready():
	set_currency_icon()
	set_skins_textures()
	play_level(B4DFramework.get_level())
	print(B4DFramework.get_settings())
	B4DFramework.on_game_ready()
	cur_stars_collected=0
	cur_stars=1


func add_star():
	cur_stars_collected += 1
	var performance = (cur_stars_collected*100)/total_stars_number
	if(performance==100)and(cur_stars<3):
		cur_stars=3
		update_game_star(cur_stars)
	elif(performance>=65)and(cur_stars<2):
		cur_stars=2
		update_game_star(cur_stars)
	elif(performance>=0)and(cur_stars<1):
		cur_stars=1
		update_game_star(cur_stars)


func set_total_stars(number:int):
	total_stars_number=number
func get_total_stars():
	return total_stars_number


func set_currency_icon() -> void:
	var currency_texture : Texture = preload("res://assets/textures/b4d_framework/coin_icon.png")
	B4DFramework.set_coin_texture(currency_texture)


func set_skins_textures() -> void:
	var skins_texture : Dictionary = {
		0 : preload("res://assets/textures/b4d_framework/Skin_1.png"),
		1 : preload("res://assets/textures/b4d_framework/Skin_2.png"),
		2 : preload("res://assets/textures/b4d_framework/Skin_3.png"),
		3 : preload("res://assets/textures/b4d_framework/Skin_4.png"),
		4 : preload("res://assets/textures/b4d_framework/Skin_5.png"),
		5 : preload("res://assets/textures/b4d_framework/Skin_6.png"),
	}
	B4DFramework.set_skins_textures(skins_texture)


func set_music(active : bool) -> void:
	get_node("Sounds").set_bg_music(active)
	pass


func set_sound(active : bool) -> void:
	pass




func stopLevel():
	# include here an input disabling command, like $Player.set_process_input(false)
	
	var player : Node = current_level.get_node("player_ball") # player node 
	player.set_process_input(false) # disable input
	
	finishGame(false)

func play_level(lvl : int):
	if current_level != null:
		current_level.queue_free()

	var l = fetch_level(lvl).instance()
	add_child(l)
	current_level = l
	cur_stars_collected = 0
	cur_stars = 1
	
	#Change Background 
	var env : WorldEnvironment = get_node("WorldEnvironment")
	env.random_bg_color()

func finishGame(level_complete : bool):
	
	var performance = (cur_stars_collected*100)/total_stars_number
	var data : Dictionary = {"performance":performance,
	"stars":cur_stars_collected}
	reset_stars()

	B4DFramework.onLevelComplete(level_complete,data)

##Get a levele from premade levels
func fetch_level(lvl : int) -> PackedScene:
	var level_path = "res://scenes/levels/level"+str(lvl)+".tscn"
	if ResourceLoader.exists(level_path):
		return ResourceLoader.load(level_path) as PackedScene
	else:
		return level_template
		#TODO : return a level auto generator
	

func level_completed(success : bool):
	var performance = (cur_stars_collected*100)/total_stars_number
	var data : Dictionary = {
		"performance":performance,
		"stars":cur_stars_collected}
	reset_stars()
	#printerr(data)
	B4DFramework.on_level_completed(success,data)

func reset_stars():
	cur_stars_collected = 0
	total_stars_number = 0

signal set_star_progress
func update_game_star(new_star:int):
	#printerr("new_star!!! ",new_star)
	emit_signal("set_star_progress",new_star)


